﻿fn shuffle arr = (
    local n = arr.count
    for i = 1 to n do (
        j = random i n
        swap arr[i] arr[j]
    )
    arr
)

rollout RandomIDRollout "随机ID材质分配器" width:200 height:140
(
    button btnRandomColor "随机颜色" width:180 height:40 align:#center
    button btnClearMat "清除材质" width:180 height:40 align:#center offset:[0,10]
    
    on btnRandomColor pressed do
    (
        if selection.count == 0 then (
            messageBox "请先选择物体！" title:"警告"
        ) else (
            objs = selection as array
            idList = for i = 1 to objs.count collect i
            shuffle(idList)
            
            multiMat = MultiMaterial()
            multiMat.numsubs = objs.count
            multiMat.name = "RandomID_MultiMat"
            
            for i = 1 to objs.count do (
                subMat = StandardMaterial()
                subMat.diffuse = color (random 0 255) (random 0 255) (random 0 255)
                multiMat.materialList[i] = subMat
            )
            
            for i = 1 to objs.count do (
                local obj = objs[i]
                obj.material = multiMat
                matMod = Materialmodifier()
                matMod.materialID = idList[i]
                addModifier obj matMod
            )
            
            messageBox ("已为 " + objs.count as string + " 个物体分配随机材质ID！") title:"完成"
        )
    )
    
    on btnClearMat pressed do
    (
        if selection.count == 0 then (
            messageBox "请先选择物体！" title:"警告"
        ) else (
            objs = selection as array
            clearedCount = 0
            
            for obj in objs do
            (
                -- 清除材质
                obj.material = undefined
                
                -- 删除材质修改器
                for i = obj.modifiers.count to 1 by -1 do
                (
                    if classOf obj.modifiers[i] == Materialmodifier do
                    (
                        deleteModifier obj i
                        clearedCount += 1
                    )
                )
            )
            
            messageBox ("已清除 " + objs.count as string + " 个物体的材质\n移除 " + clearedCount as string + " 个材质修改器") title:"完成"
        )
    )
)

createDialog RandomIDRollout style:#(#style_titlebar, #style_border, #style_sysmenu)